// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgInput.cpp
//
////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DlgInput.h"
#include "DialogHelper.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CDlgInput 

CDlgInput::CDlgInput(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgInput::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgInput)
	m_stHint = _T("");
	m_stMessage = _T("");
	m_stValue = _T("");
	//}}AFX_DATA_INIT
	m_bAcceptEmptyInput = TRUE;
}


void CDlgInput::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgInput)
	DDX_Text(pDX, IDC_STATIC_INPUT, m_stHint);
	DDX_Text(pDX, IDC_STATIC_MESSAGE, m_stMessage);
	DDX_Text(pDX, IDC_EDIT, m_stValue);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgInput, CDialog)
	//{{AFX_MSG_MAP(CDlgInput)
	ON_EN_CHANGE(IDC_EDIT, OnChangeEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CDlgInput::OnInitDialog() 
{
	CDialog::OnInitDialog();

	SetDlgItemText(IDOK, i18n("OK"));
	SetDlgItemText(IDCANCEL, i18n("Cancel"));

	SetWindowText(m_stTitle);

	ArrangeControlPair(this, IDC_STATIC_INPUT, IDC_EDIT, false);

	OnChangeEdit();
	
	return TRUE; 
}

void CDlgInput::OnChangeEdit() 
{
	if(m_bAcceptEmptyInput) return;
	
	CString stText;
	GetDlgItemText(IDC_EDIT, stText);
	
	GetDlgItem(IDOK)->EnableWindow((stText.GetLength() > 0));
}
