// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgDownload.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_DLGDOWNLOAD_H_)
#define AFX_DLGDOWNLOAD_H_

#if _MSC_VER > 1000
#pragma once
#endif

#include "resource.h"
#include "Mail.h"


/////////////////////////////////////////////////////////////////////////////
// CDlgDownload 

class CDlgDownload : public CDialog
{

public:
	CDlgDownload(CMail* pMail, CWnd* pParent = NULL); 
	virtual ~CDlgDownload();
	void OnReceivedData(const void* pData, int nDataLen);
	
	//{{AFX_DATA(CDlgDownload)
	enum { IDD = IDD_DOWNLOAD };
	CStatic	m_staticIcon;
	CProgressCtrl	m_Progress;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CDlgDownload)
	public:
	virtual BOOL DestroyWindow();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
	//}}AFX_VIRTUAL
private:
	CMail* m_pMail;
	int    m_nDataLen;
	BOOL   m_bParentDisabled;
	HWND   m_wndParent;

protected:
	BOOL Create(CWnd *pParent = NULL);
	void ReEnableParent();
	void InitGUIText();

	//{{AFX_MSG(CDlgDownload)
	virtual void OnCancel();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}

#endif // AFX_DLGDOWNLOAD_H_
