// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgDownload.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "PopMan.h"
#include "DlgDownload.h"
#include "Account.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//  i18nComment("Download Dialog")

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CDlgDownload 


CDlgDownload::CDlgDownload(CMail* pMail, CWnd* pParent /*=NULL*/)
	: CDialog(CDlgDownload::IDD, pParent)
{
	m_pMail = pMail;
	m_nDataLen = 0;
	m_bParentDisabled = FALSE;
	m_wndParent = NULL;

	Create(pParent);
	
	if(pMail)
	{
		CString stSubject(_T('"'));
		stSubject += pMail->GetSubject();
		stSubject += _T('"');
		SetDlgItemText(IDC_STATIC_SUBJECT, stSubject);
	}
	
	//{{AFX_DATA_INIT(CDlgDownload)
	//}}AFX_DATA_INIT
}

BOOL CDlgDownload::Create(CWnd *pParent)
{
	if(pParent != NULL)
		m_pParentWnd = CWnd::GetSafeOwner(pParent);
	else
	{
		CWnd* pTop = GetForegroundWindow();
		if(pTop != NULL && GetWindowThreadProcessId(pTop->GetSafeHwnd(), NULL) == GetCurrentThreadId())
			m_pParentWnd = pTop;
		else
			m_pParentWnd = AfxGetMainWnd();
	}
	
	m_wndParent = m_pParentWnd->GetSafeHwnd();

    // m_bParentDisabled dient dem Neuaufbau des bergeordneten Fensters,
    // wenn das Dialogfeld entfernt wurde. Deshalb sollte sie nicht auf TRUE 
    // gesetzt werden, es sei denn das bergeordnete Fenster war bereits aktiviert.

    if((m_pParentWnd != NULL) && m_pParentWnd->IsWindowEnabled())
    {
		m_pParentWnd->EnableWindow(FALSE);
		m_bParentDisabled = TRUE;
    }

    if(!CDialog::Create(CDlgDownload::IDD, m_pParentWnd))
    {
		ReEnableParent();
		return FALSE;
    }

    return TRUE;
}

CDlgDownload::~CDlgDownload()
{
	if(m_hWnd != NULL)
		DestroyWindow();
}

BOOL CDlgDownload::DestroyWindow() 
{
	ReEnableParent();
    return CDialog::DestroyWindow();
}

void CDlgDownload::ReEnableParent()
{
	if(m_bParentDisabled && (m_wndParent != NULL))
		::EnableWindow(m_wndParent, TRUE);

	m_bParentDisabled=FALSE;
}

void CDlgDownload::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgDownload)
	DDX_Control(pDX, IDC_STATIC_ICON, m_staticIcon);
	DDX_Control(pDX, IDC_PROGRESS, m_Progress);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgDownload, CDialog)
	//{{AFX_MSG_MAP(CDlgDownload)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL CDlgDownload::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	InitGUIText();
	m_staticIcon.SetIcon(CPopManApp::GetIcon(IDI_DOWNLOAD));

	return TRUE;  
}

void CDlgDownload::OnReceivedData(const void* pData, int nDataLen)
{
	m_nDataLen += nDataLen;

	int nPos = m_nDataLen * 100 / m_pMail->GetSize();
	m_Progress.SetPos(nPos);

	
	float fW = (float)m_nDataLen / (float)1024.0;
	float fG = (float)m_pMail->GetSize() / (float)1024.0;
	
	if(fG > 2.0)
	{
		if(fW > fG) fW = fG;
		CString stState;
		stState.Format(_T("%.0f KB / %.0f KB"), fW, fG);
		SetDlgItemText(IDC_STATIC_PROGRESS, stState);
	}
}

void CDlgDownload::OnCancel() 
{
	m_pMail->GetAccount()->Cancel();
}

void CDlgDownload::InitGUIText()
{
	SetDlgItemText(IDC_STATIC_LOADING,		i18n("Loading the following mail:"));
	SetDlgItemText(IDCANCEL,				i18n("Cancel"));
	SetWindowText(i18n("Loading Mail..."));
}
