// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgAccounts.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "PopMan.h"
#include "PopManDoc.h"
#include "DlgAccounts.h"
#include "DlgAccount.h"
#include "POP3Account.h"
#include "PluginAccount.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//  i18nComment("Accounts Dialog")
 
/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CDlgAccounts 


CDlgAccounts::CDlgAccounts(CPopManDoc* pDoc, CWnd* pParent /*=NULL*/)
	: CDialog(CDlgAccounts::IDD, pParent)
{
	m_pDoc = pDoc;
	//{{AFX_DATA_INIT(CDlgAccounts)
	//}}AFX_DATA_INIT
}


void CDlgAccounts::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgAccounts)
	DDX_Control(pDX, IDC_LIST, m_List);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgAccounts, CDialog)
	//{{AFX_MSG_MAP(CDlgAccounts)
	ON_BN_CLICKED(IDC_ACCOUNTS_ADD, OnAccountsAdd)
	ON_BN_CLICKED(IDC_ACCOUNTS_PROPERTIES, OnAccountsProperties)
	ON_BN_CLICKED(IDC_ACCOUNTS_REMOVE, OnAccountsRemove)
	ON_LBN_SELCHANGE(IDC_LIST, EnableButtons)
	ON_BN_CLICKED(IDC_ACCOUNTS_MOVE_UP, OnAccountsMoveUp)
	ON_LBN_DBLCLK(IDC_LIST, OnAccountsProperties)
	ON_BN_CLICKED(IDC_ACCOUNTS_MOVE_DOWN, OnAccountsMoveDown)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CDlgAccounts::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	FillList();
	EnableButtons();
	InitGUIText();

	m_pDoc->GetAvailableProtocols(m_Protocols);

	return TRUE;  
}

void CDlgAccounts::FillList()
{
	m_List.ResetContent();
	POSITION pos = m_pDoc->m_Accounts.GetHeadPosition();
	while(pos != NULL)
	{
		CAccount* pAcc =  m_pDoc->m_Accounts.GetNext(pos);
		int i = m_List.AddString(pAcc->m_stName);
		m_List.SetItemDataPtr(i, pAcc);
	}
}

void CDlgAccounts::OnAccountsAdd() 
{
	CDlgAccount DlgAcc(m_pDoc);
	CAccount* pAcc = NULL;
	
	CProtocol* prot = m_Protocols.GetProtocolByName(_T("IMAP4rev1 (SSL)"));
	if (prot != NULL)
	{
		pAcc = new CPluginAccount(m_pDoc, *prot);
		((CPluginAccount*)pAcc)->SetParameters(prot->GetDefaultParameters());
		((CPluginAccount*)pAcc)->m_nPort = prot->GetDefaultPort();
	}
	else 
	{
		pAcc = new CPOP3Account(m_pDoc, true);
	}	
	
	if(DlgAcc.DoModal(pAcc, m_Protocols) == IDOK)
	{
		m_pDoc->m_Accounts.AddTail(pAcc);
		// Hack: CAccount is not a CObject!
		m_pDoc->UpdateAllViews(NULL, CPopManDoc::NOTIFICATIONS::ntNewAccount, (CObject*)pAcc);
		FillList();
	}
	else
	{
		delete pAcc;
	}
}

void CDlgAccounts::OnAccountsProperties() 
{
	int iSel = m_List.GetCurSel();
	if(iSel == LB_ERR)
		return;

	CAccount* pAcc = NULL;

	try 
	{
		//pAcc = dynamic_cast<CAccount*>((CObject*)m_List.GetItemDataPtr(iSel));
		pAcc = (CAccount*)m_List.GetItemDataPtr(iSel);
		
		if(pAcc == 0)
			return;
	} 
	catch (...)
	{
		return;
	}
	
	CDlgAccount DlgAcc(m_pDoc);
	
	BOOL     bCustomColor = pAcc->m_bCustomColor;
	COLORREF CustomColor  = pAcc->m_CustomColor;


	POSITION pos = m_pDoc->m_Accounts.GetHeadPosition();
	while(pos != NULL)
	{
		CAccount* pAccLoop = m_pDoc->m_Accounts.GetNext(pos);
		if(pAccLoop == pAcc) {
			if(pos != NULL)
				m_pDoc->m_Accounts.GetPrev(pos);
			else
				pos = m_pDoc->m_Accounts.GetTailPosition();
			break;
		}
	}

	CAccount* pOldAcc = pAcc;

	if(DlgAcc.DoModal(pAcc, m_Protocols) == IDOK)
	{
		if(bCustomColor != pAcc->m_bCustomColor || CustomColor != pAcc->m_CustomColor)
		{
			CWnd* pWnd = AfxGetMainWnd();
			if(pWnd) pWnd->Invalidate();
		}

		m_pDoc->m_Accounts.GetAt(pos) = pAcc;

		CPopManDoc::AccountChangedParam param;
		param.m_pOldAccount = pOldAcc;
		param.m_pNewAccount = pAcc;
		m_pDoc->UpdateAllViews(NULL, CPopManDoc::NOTIFICATIONS::ntAccountChanged, &param);
	
		FillList();
	}
}

void CDlgAccounts::OnAccountsRemove() 
{
	if(m_pDoc->ConnectionsPending()) return;

	int iSel = m_List.GetCurSel();
	if(iSel == LB_ERR)
		return;

	CAccount* pAcc = (CAccount*)m_List.GetItemDataPtr(iSel);
	
		
	POSITION oldPos, pos = m_pDoc->m_Accounts.GetHeadPosition();
	while(pos != NULL)
	{
		oldPos = pos;
		CAccount* pAccLoop = m_pDoc->m_Accounts.GetNext(pos);
		if(pAccLoop == pAcc)
		{
			m_pDoc->m_Accounts.RemoveAt(oldPos);
			// Hack: CAccount is not a CObject!
			m_pDoc->UpdateAllViews(NULL, CPopManDoc::NOTIFICATIONS::ntAccountRemoved, (CObject*)pAcc);
			delete pAcc;
			FillList();
			return;	
		}
	}
}


void CDlgAccounts::EnableButtons() 
{
	BOOL bSelected = (m_List.GetCurSel() != LB_ERR);
	GetDlgItem(IDC_ACCOUNTS_PROPERTIES)->EnableWindow(bSelected);
	GetDlgItem(IDC_ACCOUNTS_REMOVE)->EnableWindow(bSelected);
	GetDlgItem(IDC_ACCOUNTS_MOVE_UP)->EnableWindow(bSelected && m_List.GetCurSel() > 0);
	GetDlgItem(IDC_ACCOUNTS_MOVE_DOWN)->EnableWindow(bSelected && m_List.GetCurSel() < m_List.GetCount()-1);
}

void CDlgAccounts::OnAccountsMoveUp() 
{
	if(m_pDoc->ConnectionsPending()) return;

	int Idx = m_List.GetCurSel();
	if(Idx == LB_ERR || Idx == 0) return;
	
	void* pPtrCurr = m_List.GetItemDataPtr(Idx);
	void* pPtrPre = m_List.GetItemDataPtr(Idx-1);
	if(pPtrCurr == NULL || pPtrPre == NULL) return;

	POSITION posCurr = m_pDoc->m_Accounts.Find(pPtrCurr);
	if(posCurr == NULL) return;
	m_pDoc->m_Accounts.RemoveAt(posCurr);
	
	POSITION posPre = m_pDoc->m_Accounts.Find(pPtrPre);
	if(posPre == NULL)
		m_pDoc->m_Accounts.AddHead((CAccount*)pPtrCurr);
	else
		m_pDoc->m_Accounts.InsertBefore(posPre, (CAccount*)pPtrCurr);
	
	FillList();
	m_List.SetCurSel(Idx-1); 
	EnableButtons();
}

void CDlgAccounts::OnAccountsMoveDown() 
{
	if(m_pDoc->ConnectionsPending()) return;

	int Idx = m_List.GetCurSel();
	if(Idx == LB_ERR || Idx == m_List.GetCount()-1) return;
	
	void* pPtrCurr = m_List.GetItemDataPtr(Idx);
	void* pPtrSucc = m_List.GetItemDataPtr(Idx+1);
	if(pPtrCurr == NULL || pPtrSucc == NULL) return;

	POSITION posCurr = m_pDoc->m_Accounts.Find(pPtrCurr);
	if(posCurr == NULL) return;
	m_pDoc->m_Accounts.RemoveAt(posCurr);
	
	POSITION posSucc = m_pDoc->m_Accounts.Find(pPtrSucc);
	if(posSucc == NULL)
		m_pDoc->m_Accounts.AddTail((CAccount*)pPtrCurr);
	else
		m_pDoc->m_Accounts.InsertAfter(posSucc, (CAccount*)pPtrCurr);
	
	FillList();
	m_List.SetCurSel(Idx+1); 
	EnableButtons();
}

void CDlgAccounts::InitGUIText()
{
	SetWindowText(i18n("Mail Accounts"));
	SetDlgItemText(IDC_ACCOUNTS_ADD,		i18n("&Add..."));
	SetDlgItemText(IDC_ACCOUNTS_PROPERTIES,	i18n("&Properties..."));
	SetDlgItemText(IDC_ACCOUNTS_REMOVE,		i18n("&Remove"));
	SetDlgItemText(IDC_ACCOUNTS_MOVE_UP,	i18n("Move &up"));
	SetDlgItemText(IDC_ACCOUNTS_MOVE_DOWN,	i18n("Move &down"));
	SetDlgItemText(IDOK,					i18n("&Close"));
}