// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgAccount.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_DLGACCOUNT_H_)
#define AFX_DLGACCOUNT_H_

#if _MSC_VER > 1000
#pragma once
#endif 

class CAccount;
class CPopManDoc;

#include "Plugin.h"
#include <vector>
#include "afxwin.h"

/////////////////////////////////////////////////////////////////////////////
/// CDlgAccount 

class CDlgAccount : public CPropertySheet
{
	DECLARE_DYNAMIC(CDlgAccount)

public:
	CDlgAccount(CPopManDoc* pDoc, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);
	virtual ~CDlgAccount();

public:
	//{{AFX_VIRTUAL(CDlgAccount)
	public:
	virtual int DoModal(CAccount*& pAcc, CProtocols& Protocols);
	virtual BOOL OnInitDialog();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:

	CPopManDoc* m_pDoc;

	//{{AFX_MSG(CDlgAccount)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};



/////////////////////////////////////////////////////////////////////////////////////
/// CAcc_General

class CAcc_General : public CPropertyPage
{
public:
	CAcc_General(CProtocols& Protocols, LPCTSTR szTitle = 0);
	~CAcc_General();

	//{{AFX_DATA(CAcc_General)
	enum { IDD = IDD_ACCOUNT_GENERAL };
	CComboBox	m_cboProtocols;
	CString	m_stName;
	CString	m_stUser;
	CString	m_stPass;
	CString	m_stServer;
	UINT	m_nPort;
	BOOL	m_bActive;
	//}}AFX_DATA

	CString m_stProtocolName;
	CProtocol* m_pProtocol;

	CString m_stParameters;

	//{{AFX_VIRTUAL(CAcc_General)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
	//}}AFX_VIRTUAL
	CString m_stSavedServer;

protected:
	CProtocol* GetCurrProtocol();
	void InitGUIText();
	void DDV_TextEmpty(CDataExchange* pDX, int nIDC, CString& value, LPCTSTR szMessage);

	CProtocols& m_Protocols;

	const CProtocolPlugin* m_currPlugin;

	std::vector<CString> m_vectorProtocols;

	//{{AFX_MSG(CAcc_General)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeComboProtocols();
	afx_msg void OnButtonOptions();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButtonSignIn();
	afx_msg void OnCheckVisibilityGoogleSignIn();
	afx_msg LRESULT OnGotSignInResult(WPARAM wParam, LPARAM lParam);
	CButton m_btnSignInGoogle;
};



/////////////////////////////////////////////////////////////////////
/// CAcc_Ex

class CAcc_Ex : public CPropertyPage
{
	DECLARE_DYNCREATE(CAcc_Ex)

public:
	CAcc_Ex(LPCTSTR szTitle = 0);
	~CAcc_Ex();

	//{{AFX_DATA(CAcc_Ex)
	enum { IDD = IDD_ACCOUNT_EX };
	CEdit	m_editLinesBigMails;
	CEdit	m_editMaxSizeOfSmallMails;
	CSpinButtonCtrl	m_spinMaxSizeOfSmallMails;
	CSpinButtonCtrl	m_spinLinesBigMails;
	CSpinButtonCtrl	m_spinInterval;
	CSpinButtonCtrl	m_spinLines;
	CEdit	m_editLines;
	CSliderCtrl	m_Slider;
	UINT	  m_nTimeOutVal;
	UINT	m_nLines;
	BOOL	m_bCustomAutoCheck;
	UINT	m_nAutoCheckInterval;
	BOOL	m_bUseUIDLForDelete;
	UINT	m_nLinesBigMails;
	UINT	m_nMaxSizeOfSmallMails;
	//}}AFX_DATA

    enum ACC_RETRIEVE_MODE 
	{
		AllComplete   = 0,
		AllHeaderOnly = 1,
		SmallComplete = 2
	};


    ACC_RETRIEVE_MODE m_RetrieveMode;

	//BOOL	m_bLimitLoadSize;

	//{{AFX_VIRTUAL(CAcc_Ex)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
	virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();
	void UpdateTimeOut();
	
	//{{AFX_MSG(CAcc_Ex)
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnLimitLoadMails();
	afx_msg void OnChangeEditLines();
	afx_msg void OnCheckCustomAutocheck();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};



/////////////////////////////////////////////////////////////////////
/// CAcc_Colors


class CAcc_Colors : public CPropertyPage
{
	DECLARE_DYNCREATE(CAcc_Colors)
public:
	CAcc_Colors(LPCTSTR szTitle = 0);
	~CAcc_Colors();

	BOOL	  m_bCustomColor;
	COLORREF  m_CustomColor;
	COLORREF  m_TrayColor;

	//{{AFX_DATA(CAcc_Colors)
	enum { IDD = IDD_ACCOUNT_COLORS };
	CButton	m_chkCustomColor;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CAcc_Colors)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);   
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();
	//{{AFX_MSG(CAcc_Colors)
	afx_msg void OnColorTray();
	afx_msg void OnCustomColor();
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	afx_msg void OnChooseCustomColor();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CDlgParameters 

class CDlgParameters : public CDialog
{
public:
	CDlgParameters(const CProtocol& Proto, CWnd* pParent = NULL); 

	//{{AFX_DATA(CDlgParameters)
	enum { IDD = IDD_PARAMETERS };
	CString	m_stParameters;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CDlgParameters)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX); 
	//}}AFX_VIRTUAL

protected:

	const CProtocol& m_Protocol;

	void InitGUIText();

	//{{AFX_MSG(CDlgParameters)
	afx_msg void OnDefault();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
//{{AFX_INSERT_LOCATION}}

#endif // AFX_DLGACCOUNT_H_
