// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgAccReport.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_DLGACCREPORT_H_)
#define AFX_DLGACCREPORT_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include "Account.h"
#include "resource.h"


/////////////////////////////////////////////////////////////////////////////
// CDlgAccReport 

class CDlgAccReport : public CDialog
{
public:
	CDlgAccReport(CWnd* pParent = NULL);   

	//{{AFX_DATA(CDlgAccReport)
	enum { IDD = IDD_ACCOUNTS_REPORT };
	CListCtrl	m_AccList;
	//}}AFX_DATA

	const CAccounts* m_pAccounts;

	//{{AFX_VIRTUAL(CDlgAccReport)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();
	CString GetDescription(const CAccount* pAcc);
	BOOL AddLine(LPCTSTR szAccount, LPCTSTR szDescription);

	//{{AFX_MSG(CDlgAccReport)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}

#endif // AFX_DLGACCREPORT_H_
