// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgAccReport.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "DlgAccReport.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgAccReport 

CDlgAccReport::CDlgAccReport(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgAccReport::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgAccReport)
	//}}AFX_DATA_INIT

	m_pAccounts = NULL;
}


void CDlgAccReport::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgAccReport)
	DDX_Control(pDX, IDC_LIST_ACCOUNTS, m_AccList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgAccReport, CDialog)
	//{{AFX_MSG_MAP(CDlgAccReport)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CDlgAccReport::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_AccList.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	
	m_AccList.InsertColumn(0, i18n("Account"), LVCFMT_LEFT, 100, 0);
	m_AccList.InsertColumn(1, i18n("Description"), LVCFMT_LEFT, 323, 1);
	
	if(m_pAccounts != NULL)
	{
		POSITION pos = m_pAccounts->GetHeadPosition();
		while(pos != NULL)
		{
			const CAccount* pAcc = m_pAccounts->GetNext(pos);
			if(pAcc->GetLastError() != CAccount::ERRORS::erNoError)
				AddLine(pAcc->m_stName, GetDescription(pAcc));
		}
	}

	InitGUIText();

	return TRUE;  
}


BOOL CDlgAccReport::AddLine(LPCTSTR szAccount, LPCTSTR szDescription)
{
	if(m_AccList.m_hWnd == NULL)
		return FALSE;

	LV_ITEM lvItem;
	lvItem.mask = LVIF_TEXT;
	
	// neue Zeile einfgen:
	lvItem.iItem = m_AccList.GetItemCount();
	lvItem.iSubItem = 0;
	lvItem.pszText = (LPTSTR)szAccount;
	m_AccList.InsertItem(&lvItem);

	lvItem.pszText = (LPTSTR)szDescription;
	lvItem.iSubItem = 1;
	m_AccList.SetItem(&lvItem);
	
	return TRUE;
}

CString CDlgAccReport::GetDescription(const CAccount *pAcc)
{
	CString stDescrip = pAcc->GetErrorDescription();
	if(!pAcc->m_stServerErrMessage.IsEmpty())
	{
		stDescrip += _T(" (\"");
		stDescrip += pAcc->m_stServerErrMessage;
		stDescrip += _T("\")");
	}

	if(pAcc->m_nErrorLocation)
	{
		CString stErrLoc;
		stErrLoc.Format(_T("; ErrCode: %d"), pAcc->m_nErrorLocation);
		stDescrip += stErrLoc;
	}

	return stDescrip;
}

void CDlgAccReport::InitGUIText()
{
	// SetWindowText(in("Account overview"));
	SetDlgItemText(IDOK,	i18n("OK"));
}