// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgAccImport.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_DLGACCIMPORT_H_)
#define AFX_DLGACCIMPORT_H_

#if _MSC_VER > 1000
#pragma once
#endif 


#include "resource.h"
#include "Plugin.h"


class CPopManDoc;
class CAccount;
class CPOP3Account;


class CDlgAccImport : public CDialog
{
public:
	CDlgAccImport(CPopManDoc* pDoc, BOOL bPreSelect, CWnd* pParent = NULL);  
	
	//{{AFX_DATA(CDlgAccImport)
	enum { IDD = IDD_IMPORT_ACCOUNTS };
	CStatic	m_staticIcon;
	CListCtrl	m_AccList;
	//}}AFX_DATA
	
	int LoadAccounts(BOOL bCountOnly = FALSE);
	
	//{{AFX_VIRTUAL(CDlgAccImport)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();
	CAccount* GetValidAcc(DWORD pPointer);
	void UpdateLine(int nLine, CAccount* pAcc);
	BOOL AddAccount(BOOL bIMAP, CString stAccount, CString stUser, CString stServer, DWORD dwPort);
	CPopManDoc* m_pDoc;
	
	BOOL  m_bPreSelect;

    CProtocols m_Protocols;

    int LoadAccountsOE(BOOL bCountOnly = FALSE);
    int LoadAccountsWindowsMail(BOOL bCountOnly = FALSE);

	//{{AFX_MSG(CDlgAccImport)
	virtual BOOL OnInitDialog();
	afx_msg void OnDblclkListAccounts(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnAccountProperties();
	virtual void OnOK();
	virtual void OnCancel();
	//}}AFX_MSG
	void OnItemChanged(NMHDR* pNMHDR, LRESULT* pResult);

	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}


#endif // AFX_DLGACCIMPORT_H_
