// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DialogHelper.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_DIALOGHELPER_H_)
#define AFX_DIALOGHELPER_H_

#if _MSC_VER > 1000
#pragma once
#endif 


int  GetLabelWidth(CDialog* pDlg, CWnd* pWnd);
void ArrangeControlPair(CDialog* pDlg, UINT nID1, UINT nID2, BOOL bLeftCtrlIsCheckBox = FALSE);
void ArrangeUpDown(CDialog* pDlg, UINT idLabel1, UINT idEdit, UINT idUpDown, UINT idLabel2);


template <class T>
struct RadioMapping {
public:

    RadioMapping(int idcRadio, T value) : IDCRadio(idcRadio), MappedValue(value) {}
    const int IDCRadio;
    const T   MappedValue;
};

template<class ENUM> 
void DDX_MapRadio(CDataExchange* pDX, ENUM& value, RadioMapping<ENUM> mapping[], int count)
{
	if(pDX->m_bSaveAndValidate)
	{
        for(int i = 0; i < count; ++i) 
        {
            RadioMapping<ENUM>& m = mapping[i];
            if(((CButton*)pDX->m_pDlgWnd->GetDlgItem(m.IDCRadio))->GetCheck() == 1) 
            {
                value = m.MappedValue;
                return;
            }
        }        
	}
	else
	{
        for(int i = 0; i < count; ++i) 
        {
            RadioMapping<ENUM>& m = mapping[i];
            if(value == m.MappedValue) 
            {
                ((CButton*)pDX->m_pDlgWnd->GetDlgItem(m.IDCRadio))->SetCheck(1);
                return;
            }
        }   
	}
}

#endif // AFX_DIALOGHELPER_H_