// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DialogHelper.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "DialogHelper.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


int GetLabelWidth(CDialog* pDlg, CWnd* pWnd)
{
	if(pDlg == NULL || pWnd == NULL) return 0;

	CString stText;
	pWnd->GetWindowText(stText);

	CFont* pFont = pWnd->GetFont();

	HDC screenDC = ::GetDC(0);
	HDC hDC = ::CreateCompatibleDC(screenDC);
	::ReleaseDC(0, screenDC);

	HFONT oldFont = (HFONT)::SelectObject(hDC, pFont->m_hObject);

	int nWidth = LOWORD(::GetTabbedTextExtent(hDC, stText, stText.GetLength(), 0, NULL)); 
	nWidth += LOWORD(::GetTabbedTextExtent(hDC, _T(" "), 1, 0, NULL)); 
	::SelectObject(hDC, oldFont);
	::DeleteDC(hDC);

	return nWidth;
}

void ArrangeControlPair(CDialog* pDlg, UINT nID1, UINT nID2, BOOL bLeftCtrlIsCheckBox)
{
	if(pDlg == NULL) return;

	CWnd* pWnd1 = pDlg->GetDlgItem(nID1);
	CWnd* pWnd2 = pDlg->GetDlgItem(nID2);
	if(pWnd1 == NULL || pWnd2 == NULL) return;

	int nLeftWidth = GetLabelWidth(pDlg, pWnd1);
	if(bLeftCtrlIsCheckBox)
		nLeftWidth += 25;

	CRect rect;
	pWnd1->GetWindowRect(&rect);
	pDlg->ScreenToClient(&rect);
	int nRight = rect.right = rect.left + nLeftWidth;
	pWnd1->MoveWindow(&rect);

	pWnd2->GetWindowRect(&rect);
	pDlg->ScreenToClient(&rect);
	rect.left = nRight + 5;
	pWnd2->MoveWindow(&rect);
}



void ArrangeUpDown(CDialog* pDlg, UINT idLabel1, UINT idEdit, UINT idUpDown, UINT idLabel2)
{
	if(pDlg == NULL) return;

	CWnd* pWndLabel1 = pDlg->GetDlgItem(idLabel1);
	CWnd* pWndEdit = pDlg->GetDlgItem(idEdit);
	CWnd* pWndUpDown = pDlg->GetDlgItem(idUpDown);
	CWnd* pWndLabel2 = pDlg->GetDlgItem(idLabel2);
	if(pWndLabel1 == NULL || pWndEdit == NULL || pWndUpDown == NULL || pWndLabel2 == NULL) return;

	int nLeftWidth = GetLabelWidth(pDlg, pWndLabel1);

	CRect rect;
	pWndLabel1->GetWindowRect(&rect);
	pDlg->ScreenToClient(&rect);
	int nRightLabel = rect.right = rect.left + nLeftWidth;
	pWndLabel1->MoveWindow(&rect);

	pWndEdit->GetWindowRect(&rect);
	pDlg->ScreenToClient(&rect);
	int nWidthEdit = rect.Width();
	int nLeftEdit = rect.left;
	rect.left = nRightLabel + 5;
	int nRightEdit = rect.right = rect.left + nWidthEdit;
	pWndEdit->MoveWindow(&rect);
	int nEditMovement = rect.left - nLeftEdit;

	pWndUpDown->GetWindowRect(&rect);
	pDlg->ScreenToClient(&rect);
	int nWidthUpDown = rect.Width();
	rect.left += nEditMovement;
	rect.right = rect.left + nWidthUpDown;
	pWndUpDown->MoveWindow(&rect);

	pWndLabel2->GetWindowRect(&rect);
	pDlg->ScreenToClient(&rect);
	int nWidthLabel2 = rect.Width();
	rect.left = nRightEdit + nWidthUpDown + 4;
	rect.right = rect.left + nWidthLabel2;
	pWndLabel2->MoveWindow(&rect);
}




