// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ColorStatusBar.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_COLORSTATUSBAR_H_)
#define AFX_COLORSTATUSBAR_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include "ToolTip.h"


class CColorStatusBar : public CStatusBar
{
public:

	CColorStatusBar();
	virtual ~CColorStatusBar();

	BOOL SetIndicators(const UINT* lpIDArray, int nIDCount);
	
	void GetPaneText(int nIndex, CString& rString) const;
	CString GetPaneText(int nIndex) const;
	BOOL SetPaneText(int nIndex, LPCTSTR lpszNewText, BOOL bUpdate = TRUE);
	void SetPaneTextColor(int nIndex, COLORREF TextColor);
	COLORREF GetPaneTextColor(int nIndex);

	typedef void (*CallBackFn)(int);

	CallBackFn m_fnOnPaneDblClick;
	
	virtual void DrawItem(LPDRAWITEMSTRUCT);

	//{{AFX_VIRTUAL(CColorStatusBar)
	//}}AFX_VIRTUAL

protected:
	int GetPaneFromPoint(POINT ptPoint, BOOL bScreen);
	void ShowToolTip(int nPaneIdx);
	void HideToolTip();
	void StopTimer();
	void StartTimer();
	BOOL IsToolTipNeeded(int nPaneIdx);
	int GetCurrentPane();

	BOOL IsOwnerDrawn(int PaneIdx) const;
	//{{AFX_MSG(CColorStatusBar)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	//}}AFX_MSG
	
	struct PaneInfo
	{
		CString Text;
		COLORREF TextColor;
		BOOL bOwnerDrawn;
	};
	
	PaneInfo *PaneArray;
	int		m_nPaneCount;

	int m_nTimerID;
	int m_nCurrPane;

	CToolTip m_ToolTip;

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif // AFX_COLORSTATUSBAR_H_
