// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// AutoUpdate.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_AUTOUPDATE_H_)
#define AFX_AUTOUPDATE_H_

#if _MSC_VER > 1000
#pragma once
#endif

#include "resource.h"
#include "Version.h"
#include "StaticLink.h"
#include <afxtempl.h>


/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////


class CAutoUpdate_Page_One : public CPropertyPage
{
	DECLARE_DYNCREATE(CAutoUpdate_Page_One)
public:
	CAutoUpdate_Page_One();
	~CAutoUpdate_Page_One();

	//{{AFX_DATA(CAutoUpdate_Page_One)
	enum { IDD = IDD_AUTOUPDATE_ONE };
	CStatic	m_staticIcon;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CAutoUpdate_Page_One)
	public:
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();

	virtual BOOL OnInitDialog();
	virtual BOOL OnQueryCancel();

	static BOOL NewVersionAvailable(const CString& stData, CVersion& Version, CString& stInfoLink);
	
	CFont  m_FontStatic;
	CBrush m_BkgBrush;
	CStaticLink m_Link;

	BOOL   m_bError;

	//{{AFX_MSG(CAutoUpdate_Page_One)
	//}}AFX_MSG
	
	afx_msg LRESULT OnDownloadComplete(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDownloadFailed(WPARAM wParam, LPARAM lParam);

	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);

	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

typedef int (CALLBACK *BuffToBuffDecompressFn)(char*, unsigned int*, char*, unsigned int, int, int);

class CAutoUpdate_Page_Two : public CPropertyPage
{
	DECLARE_DYNCREATE(CAutoUpdate_Page_Two)

public:
	CAutoUpdate_Page_Two();
	~CAutoUpdate_Page_Two();

	//{{AFX_DATA(CAutoUpdate_Page_Two)
	enum { IDD = IDD_AUTOUPDATE_TWO };
	//}}AFX_DATA
	
	CProgressCtrl	m_ProgressAll;
	CProgressCtrl	m_ProgressCurrent;

	//{{AFX_VIRTUAL(CAutoUpdate_Page_Two)
	public:
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);   
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();

	BOOL StartDownloadingFile(int nFileIdx);
	
	static DWORD  GetDataCheckSum(const CString& stData);
	static DWORD  GetFileCheckSum(LPCTSTR szFile);
	static inline void CalcCrc32(const BYTE byte, DWORD& dwCrc32);
	static DWORD* m_pdwCrc32Table;
	
	BOOL	m_bProcessing;
	BOOL    m_bError;
	CBrush  m_BkgBrush;
	CFont   m_FontStatic;

	enum UPDATESTATE
	{
		updInit = 0,
		updFileDownload = 1,
	};

	UPDATESTATE m_UpdateState;

	struct FILESIGNATURE
	{
		CString stName;
		DWORD	dwSize;
		DWORD	dwCRC;
		BOOL	bCompressed;
		DWORD	dwSizeCompressed;
	};
	typedef CArray<FILESIGNATURE, FILESIGNATURE&> CFileSignatures;
	static CFileSignatures m_LocalFiles;
	static CFileSignatures m_NewFiles;
	int m_nCurrentFile;
	CString m_stServer;
	CString m_stBaseDir;
	CString m_stRestartCmd;
	CString m_stLocalBaseDir;
	int		m_nTotalDownloadSize;
	int		m_nBytesDownloaded;

	static BOOL ParseVersionFile(CString stData, CString& stServer, CString& stBaseDir, CString& stVersion, CString& stRestartCmd, CFileSignatures& Files);
	static void ListDir(CFileSignatures& Files, LPCTSTR szDir, LPCTSTR szBaseDir);
	static BOOL CreateDirectoryRec(LPCTSTR szDir);
	static UINT InitThread(LPVOID lParam);
	void Error(LPCTSTR szError, BOOL bResetProgress = FALSE);

	
	static BOOL Decompress(const CString& stIn, CString& stOut);

	static HINSTANCE				m_hDecompressDLL;
	static BuffToBuffDecompressFn	m_fnDecompress;

	//{{AFX_MSG(CAutoUpdate_Page_Two)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	virtual BOOL OnQueryCancel();
	virtual BOOL OnWizardFinish();

	afx_msg LRESULT OnDownloadComplete(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDownloadFailed(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDownloadProgress(WPARAM wParam, LPARAM lParam);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);

	DECLARE_MESSAGE_MAP()
};


class CDlgAutoUpdate : public CPropertySheet
{
	DECLARE_DYNAMIC(CDlgAutoUpdate)

public:
	CDlgAutoUpdate(CWnd* pParentWnd = NULL, UINT iSelectPage = 0);
	virtual ~CDlgAutoUpdate();

	//{{AFX_VIRTUAL(CDlgAutoUpdate)
	public:
	virtual int DoModal();
	//}}AFX_VIRTUAL

	static CVersion vNewVersion;

protected:
	CAutoUpdate_Page_One m_PageOne;
	CAutoUpdate_Page_Two m_PageTwo;
	virtual BOOL OnInitDialog();

	//{{AFX_MSG(CDlgAutoUpdate)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


//{{AFX_INSERT_LOCATION}}


#endif // AFX_AUTOUPDATE_H_
