// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Attachment.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_ATTACHMENT_H_)
#define AFX_ATTACHMENT_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include <afxtempl.h>


class CAttachment;
typedef CTypedPtrList<CPtrList, CAttachment*> CAttachments;


class CAttachment : public CObject  
{
public:

	CAttachment(const CString& stFileName, const CString& stContent, BOOL bComplete);
	virtual ~CAttachment();

	const CString& GetFileName()	 const  { return m_stFileName;     }
	const CString& GetExtension()	 const  { return m_stExtension;    }
	const CString& GetContent()		 const  { return m_stContent;      }
	const CString& GetSizeFormated() const  { return m_stSizeFormated; }
	int			   GetSize()		 const  { return m_nSize;          }
	BOOL		   IsComplete()		 const  { return m_bComplete;      }
	BOOL		   IsExecuteable()   const;

	void			Complete(const CString& stFileName, const CString& stContent);
	
protected:

	CString m_stFileName;
	CString m_stContent;
	CString m_stExtension;
	CString m_stSizeFormated;
	int		m_nSize;
	BOOL	m_bComplete;

	void Init(const CString& stFileName, const CString& stContent, BOOL bComplete);
};

#endif 
