// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Attachment.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "Attachment.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CAttachment::CAttachment(const CString& stFileName, const CString& stContent, BOOL bComplete)
{
	Init(stFileName, stContent, bComplete);
}

CAttachment::~CAttachment()
{

}

BOOL CAttachment::IsExecuteable() const
{
	LPCTSTR Extensions[] = {
	    _T("exe"),
		_T("com"),
		_T("bat"),
		_T("vbs"),
		_T("js"),
		_T("scr"),
		_T("pif"),
		_T("lnk"),
		_T("wsf"),
	    _T("wsh"),
		_T("vxd"),
		_T("jse"),
		_T("rm"),
		_T("vbe"),
		_T("xl"),
		_T("do"),
		_T("cmd"),
	};

	for(int n = 0; n < sizeof(Extensions)/sizeof(Extensions[0]); n++)
	{
		if(m_stExtension.CompareNoCase(Extensions[n]) == 0)
			return TRUE;
	}

	return FALSE;
}


void CAttachment::Complete(const CString& stFileName, const CString& stContent)
{
	Init(stFileName, stContent, TRUE);
}	

void CAttachment::Init(const CString& stFileName, const CString& stContent, BOOL bComplete)
{
	m_nSize = stContent.GetLength();
	m_stFileName = stFileName;
	m_stContent = stContent;
	m_bComplete = bComplete;

	float fSizeKB = (float)m_nSize/(float)1024.0;
	if (fSizeKB < 1.0 && fSizeKB > 0.0) fSizeKB = 1.0;
	m_stSizeFormated.Format(_T("%.0f KB"), fSizeKB);


	int Idx = stFileName.ReverseFind(_T('.'));
	if(Idx == -1)
		m_stExtension = _T("");
	else
		m_stExtension = stFileName.Mid(Idx+1);
}