using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Text;

namespace TestApp
{
	/// <summary>
	/// Zusammendfassende Beschreibung fr Form1.
	/// </summary>
	public class frmMain : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button cmdOpen;
		internal System.Windows.Forms.Button cmdFont;
		internal System.Windows.Forms.Label lblCodepageState;
		internal System.Windows.Forms.Label lblCharset;
		internal System.Windows.Forms.Label lblCodepage;
		internal System.Windows.Forms.Label Label2;
		internal System.Windows.Forms.Label Label1;
		internal System.Windows.Forms.TextBox txtData;
		internal System.Windows.Forms.OpenFileDialog OpenDialog;
		internal System.Windows.Forms.FontDialog FontDialog;
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmMain()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();

			//
			// TODO: Fgen Sie den Konstruktorcode nach dem Aufruf von InitializeComponent hinzu
			//
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.cmdOpen = new System.Windows.Forms.Button();
			this.cmdFont = new System.Windows.Forms.Button();
			this.lblCodepageState = new System.Windows.Forms.Label();
			this.lblCharset = new System.Windows.Forms.Label();
			this.lblCodepage = new System.Windows.Forms.Label();
			this.Label2 = new System.Windows.Forms.Label();
			this.Label1 = new System.Windows.Forms.Label();
			this.txtData = new System.Windows.Forms.TextBox();
			this.OpenDialog = new System.Windows.Forms.OpenFileDialog();
			this.FontDialog = new System.Windows.Forms.FontDialog();
			this.SuspendLayout();
			// 
			// cmdOpen
			// 
			this.cmdOpen.Location = new System.Drawing.Point(4, 7);
			this.cmdOpen.Name = "cmdOpen";
			this.cmdOpen.Size = new System.Drawing.Size(124, 24);
			this.cmdOpen.TabIndex = 10;
			this.cmdOpen.Text = "Open HTML file...";
			this.cmdOpen.Click += new System.EventHandler(this.cmdOpen_Click);
			// 
			// cmdFont
			// 
			this.cmdFont.Location = new System.Drawing.Point(4, 31);
			this.cmdFont.Name = "cmdFont";
			this.cmdFont.Size = new System.Drawing.Size(124, 24);
			this.cmdFont.TabIndex = 11;
			this.cmdFont.Text = "Select font...";
			this.cmdFont.Click += new System.EventHandler(this.cmdFont_Click);
			// 
			// lblCodepageState
			// 
			this.lblCodepageState.Location = new System.Drawing.Point(376, 31);
			this.lblCodepageState.Name = "lblCodepageState";
			this.lblCodepageState.Size = new System.Drawing.Size(312, 20);
			this.lblCodepageState.TabIndex = 16;
			this.lblCodepageState.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblCharset
			// 
			this.lblCharset.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.lblCharset.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.lblCharset.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblCharset.Location = new System.Drawing.Point(240, 7);
			this.lblCharset.Name = "lblCharset";
			this.lblCharset.Size = new System.Drawing.Size(128, 20);
			this.lblCharset.TabIndex = 12;
			this.lblCharset.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.lblCharset.UseMnemonic = false;
			// 
			// lblCodepage
			// 
			this.lblCodepage.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.lblCodepage.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.lblCodepage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblCodepage.Location = new System.Drawing.Point(240, 31);
			this.lblCodepage.Name = "lblCodepage";
			this.lblCodepage.Size = new System.Drawing.Size(128, 20);
			this.lblCodepage.TabIndex = 15;
			this.lblCodepage.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.lblCodepage.UseMnemonic = false;
			// 
			// Label2
			// 
			this.Label2.Location = new System.Drawing.Point(176, 31);
			this.Label2.Name = "Label2";
			this.Label2.Size = new System.Drawing.Size(64, 20);
			this.Label2.TabIndex = 14;
			this.Label2.Text = "Codepage:";
			this.Label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// Label1
			// 
			this.Label1.Location = new System.Drawing.Point(176, 7);
			this.Label1.Name = "Label1";
			this.Label1.Size = new System.Drawing.Size(56, 20);
			this.Label1.TabIndex = 13;
			this.Label1.Text = "Charset:";
			this.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtData
			// 
			this.txtData.AcceptsReturn = true;
			this.txtData.AcceptsTab = true;
			this.txtData.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txtData.Font = new System.Drawing.Font("Courier New", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtData.Location = new System.Drawing.Point(4, 64);
			this.txtData.Multiline = true;
			this.txtData.Name = "txtData";
			this.txtData.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtData.Size = new System.Drawing.Size(714, 475);
			this.txtData.TabIndex = 17;
			this.txtData.Text = "";
			// 
			// OpenDialog
			// 
			this.OpenDialog.DefaultExt = "htm";
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(720, 541);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.txtData,
																		  this.cmdOpen,
																		  this.cmdFont,
																		  this.lblCodepageState,
																		  this.lblCharset,
																		  this.lblCodepage,
																		  this.Label2,
																		  this.Label1});
			this.Name = "frmMain";
			this.Text = "HTML to text";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new frmMain());
		}

		private void cmdOpen_Click(object sender, System.EventArgs e)
		{
			OpenDialog.Filter = "HTML files|*.htm;*.html;*.shtm;*.shtml";
			if(OpenDialog.ShowDialog() != DialogResult.OK) return;

			System.IO.StreamReader Reader = new System.IO.StreamReader(OpenDialog.FileName, Encoding.Default);
			string stHtml = Reader.ReadToEnd();
			Reader.Close();

			int nCodePage;
			string stText, stCharset;

			if(chHtmlConvert.HtmlConvert.ExtractPlainText(stHtml, out stText, true, out stCharset, out nCodePage))
				lblCodepageState.Text = "";
			else
				lblCodepageState.Text = "The required codepage is not available!";

			txtData.Text = stText;
			lblCodepage.Text = nCodePage.ToString();
			lblCharset.Text = stCharset;

		}

		private void cmdFont_Click(object sender, System.EventArgs e)
		{
			FontDialog.Font = txtData.Font;
			if (FontDialog.ShowDialog() != DialogResult.OK) return;
			txtData.Font = FontDialog.Font;
		}
	}
}
