// HtmlDlg.cpp 

#include "stdafx.h"
#include "Html.h"
#include "HtmlDlg.h"
#include <malloc.h>
#include "chHtmlConvert32.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);  
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// CHtmlDlg 

CHtmlDlg::CHtmlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHtmlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHtmlDlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CHtmlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHtmlDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CHtmlDlg, CDialog)
	//{{AFX_MSG_MAP(CHtmlDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_OPEN, OnOpenHTML)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_FONT, OnSelectFont)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




BOOL CHtmlDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{	
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			
	SetIcon(m_hIcon, FALSE);	
	
	m_Font.CreatePointFont(115, _T("Courier New"));
	GetDlgItem(IDC_EDIT_TEXT)->SetFont(&m_Font);
	return TRUE;  
}

void CHtmlDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CHtmlDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); 

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CHtmlDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}



void CHtmlDlg::OnOpenHTML() 
{
	OPENFILENAME ofn;
	TCHAR szFileName[MAX_PATH] = _T(""); 
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = 0;
	ofn.lpstrFilter = _T("HTML files\0*.htm;*.html;*.shtm;*.shtml\0");
	ofn.lpstrFile = szFileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	
	
	if(!GetOpenFileName(&ofn))
		return;
	
	
	CFile File(szFileName, CFile::modeRead);
	
	CString stHtml;
	int nLen = File.GetLength();

#ifndef _UNICODE

	LPSTR szData = stHtml.GetBuffer(nLen+1);
	File.Read(szData, nLen);
	stHtml.ReleaseBuffer(nLen);

#else

	char* pBuf = (char*)alloca(nLen);
	File.Read(pBuf, nLen);
	
	WCHAR* pwBuf = stHtml.GetBuffer(nLen+1);
	MultiByteToWideChar(CP_ACP, 0, pBuf, nLen, pwBuf, nLen);
	stHtml.ReleaseBuffer(nLen);

#endif
	
	File.Close();

	CString stText;
	LPTSTR szText = stText.GetBuffer(stHtml.GetLength()+1);

	TCHAR szCharset[32] = _T("");
	UINT  nCodepage = 0;

	BOOL bCodepageSupported = HTMLToText(stHtml, szText, TRUE, szCharset, sizeof(szCharset)/sizeof(TCHAR), &nCodepage);
	
	stText.ReleaseBuffer();

	SetDlgItemText(IDC_EDIT_TEXT, stText);

	if(bCodepageSupported == FALSE)
		SetDlgItemText(IDC_STATIC_MESSAGE, _T("The required codepage is not available!"));
	else
		SetDlgItemText(IDC_STATIC_MESSAGE, _T(""));


	CString stFormat;
	stFormat.Format(_T(" %d"), nCodepage);
	SetDlgItemText(IDC_STATIC_CODEPAGE, stFormat);
	stFormat.Format(_T(" %s"), szCharset);
	SetDlgItemText(IDC_STATIC_CHARSET, stFormat);

}

void CHtmlDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	CWnd * pWnd = GetDlgItem(IDC_EDIT_TEXT);	
	if(pWnd == NULL) return;

	RECT rect;
	pWnd->GetWindowRect(&rect);
	ScreenToClient(&rect);

	int xOffset = rect.left;
	int yOffset = rect.top;

	pWnd->MoveWindow(xOffset, yOffset, cx - 2*xOffset, cy - yOffset - xOffset);
}

void CHtmlDlg::OnSelectFont() 
{
	LOGFONT lgFont;
	m_Font.GetLogFont(&lgFont);
	
	CFontDialog fDlg(&lgFont, CF_SCREENFONTS);
	if(IDOK != fDlg.DoModal())
		return;
	
	m_Font.DeleteObject();
	
	fDlg.GetCurrentFont(&lgFont);
	m_Font.CreateFontIndirect(&lgFont);
	GetDlgItem(IDC_EDIT_TEXT)->SetFont(&m_Font);
}
