unit Main;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus;

type
  TMainForm = class(TForm)
    cmdOpen: TButton;
    cmdFont: TButton;
    txtData: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Panel1: TPanel;
    lblCharset: TLabel;
    Panel2: TPanel;
    lblCodepage: TLabel;
    OpenDialog: TOpenDialog;
    FontDialog: TFontDialog;
    lblCodepageState: TLabel;
    procedure cmdOpenClick(Sender: TObject);
    procedure cmdFontClick(Sender: TObject);
  end;

  function HTMLToText(stHtml, stText: PChar; bPreferASCII: Integer; stCharset: PChar; nCharsetLen: Integer; var nCodepage: Cardinal): Integer;
             stdcall; external 'chHTMLConvert32.dll' name 'HTMLToTextA';

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.cmdOpenClick(Sender: TObject);
var StringList: TStringList;
    stHtml: String;
    stText: String;
    stCharset: String;
    nCodepage: Cardinal;
begin
     OpenDialog.Filter := 'HTML files|*.htm;*.html;*.shtm;*.shtml';
     if OpenDialog.Execute() = false then exit;

     StringList := TStringList.Create();
     StringList.LoadFromFile(OpenDialog.FileName);
     stHtml := StringList.Text;
     StringList.Free;

     SetLength(stText, Length(stHtml)+1);
     SetLength(stCharset, 32);

     if 1 = HTMLToText(PChar(stHtml), PChar(stText), 1, PChar(stCharset), Length(stCharset), nCodepage) then
        lblCodepageState.Caption := ''
     else
        lblCodepageState.Caption := 'The required codepage is not available!';

     txtData.Text := stText;
     lblCharset.Caption := stCharset;
     lblCodepage.Caption := IntToStr(nCodepage);

end;

procedure TMainForm.cmdFontClick(Sender: TObject);
begin
     FontDialog.Options := [];
     FontDialog.Font := txtData.Font;
     if FontDialog.Execute() = false then exit;
     txtData.Font := FontDialog.Font;
end;

end.
